require( "scripts/style.lua" );


MyFont = {
  standardFont,
  30,
  BorderColor
};

NameFont = {
  standardFont,
  18,
  BorderColor
};



local startname = gEnterNameValue;
local descriplabel = gEnterNameDescrip;
local checkNameFunc = gEnterNameCheckFunction;
local illegalChars = gIllegalChars;
local maxInput = gMaxInput;
if (maxInput <= 0) then
	maxInput = 1000;
end

local textfieldImage = gTextFieldImage;
if (textfieldImage == nil or textfieldImage == "") then
	textfieldImage = "backgrounds/textfield.png"
end

local fontSize = gFontSize;
if (fontSize == nil or fontSize == "") then
	fontSize = 18;
end

NameFont = {
  standardFont,
  fontSize,
  BorderColor
};




MakeDialog
{
	PopThroughBitmap
	{ 
		image="backgrounds/popup",
		x=kCenter,
		y=kCenter,
		
		EnterNameWindow
		{
			x=0,y=0,w=kMax,h=kMax,
			Text
			{
				font = MyFont,
				x=0,y=35,w=kMax,h=30,
				flags = kHAlignCenter + kVAlignTop,
				label = descriplabel
			};
			
			Bitmap
			{
				image=textfieldImage,
				x=kCenter,
				y=95,
				
				TextEdit
				{
					font = NameFont,
					name = "nameedit",
					label = startname,
					x=5,y=6,w=kMax-5,h=kMax,
					length=maxInput,
					ignore = gIllegalChars
					
				};
			};
				
			SetStyle(StandardButtonStyle);
			Button
			{
				x=35,
				y=145,
				name="enterok",
				label="ok",
				default = true,
				command = 
					function()
						if (not(checkNameFunc == nil)) then
							if (checkNameFunc(GetLabel("nameedit"))) then
								DisplayDialog { 
									"scripts/ok.lua", 
									body ="nameinuse",
									title = ""
								};
								SetFocus( "nameedit" )
							else
								CloseWindow(GetLabel("nameedit"));
							end
						else
							CloseWindow(GetLabel("nameedit"));
						end
						
					end
			},
			
			
			
			Button
			{
				x=235,
				y=145,
				name="entercancel",
				label="cancel",
				command = 
					function()
						CloseWindow(nil);
					end
			};
			
			
			SetStyle(DefaultStyle);
			
		}
		
	},
	
	
}

SetFocus( "nameedit" );
gIllegalChars = '';
gMaxInput = 0;



